package topdown.term;

import topdown.data_structures.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Term {

    @Override
    public String toString();
    
    @Override
    public boolean equals(Object obj);

    @Override
    public int hashCode();
    
    public Term substitute(Map<Variable, Term> substitution);

    public Term copy();
    
    /* method returns true and finds substitution in case it's possible
     * returns false otherwise */
    public static boolean match(Term t, Term s, Map<Variable, Term> substitution) {
        if (t instanceof Variable) {
            Variable v = (Variable) t;
            if (substitution.get(v) == null) {
                substitution.put(v, s.copy());
                return true;
            } else {
                return substitution.get(v).equals(s);
            }
        } else if (t instanceof FunctionalSymbol && s instanceof FunctionalSymbol) {
            FunctionalSymbol f = (FunctionalSymbol) t;
            FunctionalSymbol g = (FunctionalSymbol) s;
            if (f.arity == g.arity && f.symbol.equals(g.symbol)) {
                for (int i=0; i<f.arity; i++) {
                    if (!match(f.arguments.get(i), g.arguments.get(i), substitution)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }
    
}
